/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.std.xml;

import com.quantumdata.std.xml.DbNode;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DbUtil {
    public static DbNode loadDocument(String string, String string2) {
        return DbUtil.loadDocument(new File(string), string2);
    }

    public static DbNode loadDocument(File file, String string) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            DbUtil.addErrorHandler(documentBuilder);
            document = documentBuilder.parse(file);
            return DbUtil.getRoot(document, string);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            System.out.println(((Throwable)exception).getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.out.println(parserConfigurationException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
        return null;
    }

    public static DbNode newDocument(String string) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
            Element element = document.createElement(string);
            document.appendChild(element);
            return new DbNode(document, element);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            return null;
        }
    }

    public static boolean saveDocument(DbNode dbNode, String string) {
        return DbUtil.saveDocument(dbNode, new File(string));
    }

    public static boolean saveDocument(DbNode dbNode, File file) {
        if (dbNode.getDocument() == null) {
            return false;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            DOMSource dOMSource = new DOMSource(dbNode.getDocument());
            StreamResult streamResult = new StreamResult(fileOutputStream);
            transformer.transform(dOMSource, streamResult);
            fileOutputStream.close();
            return true;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            System.out.println("\n** Transformer Factory error");
            System.out.println("   " + transformerConfigurationException.getMessage());
        }
        catch (TransformerException transformerException) {
            System.out.println("\n** Transformation error");
            System.out.println("   " + transformerException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
        return false;
    }

    public static void addSchemaAttrs(DbNode dbNode, String string) {
        DbUtil.addSchemaAttrs(dbNode, string, false);
    }

    public static void addSchemaAttrs(DbNode dbNode, String string, boolean bl) {
        if (dbNode.getName().startsWith("ipo:")) {
            dbNode.addAttr("xmlns:ipo", "http://www.quantumdata.com/schema");
        } else {
            dbNode.addAttr("xmlns", "http://www.quantumdata.com/schema");
        }
        dbNode.addAttr("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        if (bl) {
            dbNode.addAttr("lastUpdate", "123456");
        }
    }

    private static void addErrorHandler(DocumentBuilder documentBuilder) {
        documentBuilder.setErrorHandler(new ErrorHandler(){

            public void warning(SAXParseException sAXParseException) throws SAXException {
                System.out.println("** Warning, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
                System.out.println("   " + sAXParseException.getMessage());
            }

            public void error(SAXParseException sAXParseException) throws SAXException {
                throw sAXParseException;
            }

            public void fatalError(SAXParseException sAXParseException) throws SAXException {
            }
        });
    }

    private static DbNode getRoot(Document document, String string) {
        NodeList nodeList = document.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equalsIgnoreCase(string)) continue;
            return new DbNode(node);
        }
        return null;
    }
}

